//
//  NSURL+Additions.m
//  Twitch Plugin
//
//  Created by Auston Stewart on 7/25/14.
//  Copyright (c) 2014 Twitch Interactive, Inc. All rights reserved.
//

#import "NSURLAdditions.h"

@implementation NSURL (Additions)

- (NSDictionary *) _tw_dictionaryFromParameterString:(NSString *) string {
	NSArray *components = [string componentsSeparatedByString:@"&"];
	if (!components.count)
		return nil;
	
	NSMutableDictionary *dictionary = [NSMutableDictionary dictionary];
	for (NSString *component in components) {
		NSArray *parameterComponents = [component componentsSeparatedByString:@"="];
		if (!parameterComponents.count)
			continue;
		
		if (parameterComponents.count == 1)
			dictionary[parameterComponents[0]] = @"";
		else dictionary[parameterComponents[0]] = parameterComponents[1];
	}
	
	return dictionary;
}

- (NSDictionary *) tw_fragmentDictionary {
	return [self _tw_dictionaryFromParameterString:self.fragment];
}

- (NSDictionary *) tw_queryDictionary {
	return [self _tw_dictionaryFromParameterString:self.query];
}

@end
